DROP PROCEDURE [hips].[PcehrMessageQueueUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 6 December 2012
-- Description:   Updates an existing record in the PcehrMessageQueue  Table
-- Modified:
-- 29/01/2013 sbiber			added EpisodeId
-- 15/09/2013 pstalley-gordon	added SourceSystemSetId & SourceSystemDocumentId
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueUpdate] 
(
	@PcehrMessageQueueId int,
	@EpisodeId           int,
	@SourceSystemSetId varchar(128),
	@SourceSystemDocumentId varchar(128) = NULL,
    @QueueOperationId    int,
	@QueueStatusId       int,
	@SerialisedObject    varbinary(max),
	@Request             xml = NULL,
	@Response            xml = NULL,
	@Details             varchar(max) = NULL,
	@UserModified        varchar(256),
	@DateModified        datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[PcehrMessageQueue]
				WHERE [PcehrMessageQueueId] = @PcehrMessageQueueId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[PcehrMessageQueue]
           SET	 [EpisodeId] = @EpisodeId
				,[QueueOperationId] = @QueueOperationId
				,[QueueStatusId] = @QueueStatusId
				,[SerialisedObject] = @SerialisedObject
				,[Request] = @Request
				,[Response] = @Response
				,[Details] = @Details
				,[DateModified] = GetDate()
				,[UserModified] = @UserModified
         WHERE [PcehrMessageQueueId] = @PcehrMessageQueueId
        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT [PcehrMessageQueueId]
		   ,pmq.[EpisodeId]
           ,pmq.[QueueOperationId]
		   ,qo.[Description] AS [QueueOperationName]
           ,pmq.[QueueStatusId]
		   ,qs.[Description] AS [QueueStatusDescription]
           ,[SerialisedObject]
           ,[Request]
           ,[Response]
           ,[Details]
           ,pmq.[DateCreated]
           ,pmq.[UserCreated]
           ,pmq.[DateModified]
           ,pmq.[UserModified]
         FROM [hips].[PcehrMessageQueue] pmq
		 INNER JOIN [hips].[QueueOperation] qo ON pmq.[QueueOperationId] = qo.[QueueOperationId]
		 INNER JOIN [hips].[QueueStatus] qs ON pmq.[QueueStatusId] = qs.[QueueStatusId]
         WHERE [PcehrMessageQueueId] = @PcehrMessageQueueId
    END

    RETURN(@intErrorCode)

END
GO

